% initialization


%% Without user input

Eb = 1;
SNR = 30;
modulation_decision = 1;
QAM_decision = 16;
OFDM_decision = 1;


%% Intialization parameters

% sampling frequency in Hz
fs = 44100;
Ts = 1/fs;

% carrier frequency in Hz (this has to be the carrier frequency divided by
% an integer m. Center frequency for OFDM
m = 5;
f0 = 44100/m;
T0 = 1/f0;

% symbol time (absolute time) corresponding to reciproke symbol rate
% This has to be 1 for OFDM!

if OFDM_decision == 1
    k = 1;
else
    k = 5;
end

R = fs/k;
Tr = 1/R;

% This is the pulse used for pulse shaping! For now it is only a boxcar
% This is only without OFDM!
pulse = ones(1,k);

% OFDM parameters
BlockLength = 128;
N = 3*BlockLength;
L = 16;

% package parameters
nr_databits_package = 4*12*BlockLength; %12* 1920; %6144*4;%1920;
nr_training_bits_package = 12*BlockLength; %384; %6144; %384;
package_length_bits = nr_databits_package + nr_training_bits_package;

% bytes per sample for recording
bytes_per_sample = 2;

% number of bytes per buffer
nr_bytes_per_buffer = 4096;

% number of time instants that can be saved in one buffer
nr_samples_per_buffer = nr_bytes_per_buffer / bytes_per_sample;

% number of buffers
nr_buffers = 2;

